<?php

require_once 'conf.php';

if($_SERVER['REQUEST_METHOD'] == 'POST'){
    $conexion = conexion($bd_config);
    $inicio = $_POST['inicio'];
    $fin = $_POST['fin'];
    $search = $conexion->prepare('SELECT * FROM cuestionario_covid WHERE fecha_reg BETWEEN :inicio AND :fin');
    $search->execute(array(':inicio' => $inicio, ':fin' => $fin));
    $all = $search->fetchAll();
}else{
    $conexion = conexion($bd_config);
    $bringall = $conexion->prepare('SELECT * FROM cuestionario_covid');
    $bringall->execute();
    $all = $bringall->fetchAll();
}

?>

<!doctype html>
<html lang="en">
  <head>
    <title>Title</title>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T" crossorigin="anonymous">
    <link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
  </head>
  <body>
      
    <div class="container">
        <form action="" method="post">
            <div class="row mt-5">
                <div class="col-12 col-md-6">
                    <div class="form-group">
                        <label for="inicio">Fecha Inicio:</label>
                        <input type="text" class="form-control" id="inicio" name="inicio">
                    </div>
                </div>
                <div class="col-12 col-md-6">
                    <div class="form-group">
                        <label for="inicio">Fecha Inicio:</label>
                        <input type="text" class="form-control" id="fin" name="fin">
                    </div>
                </div>
                <div class="col-5">
                    <div class="form-group">
                        <input type="submit" value="Buscar" class="btn btn-primary">
                    </div>
                </div>
            </div>
        </form>
    </div>

    <div class="container">
        <div class="row">
            <div class="col-12">
                <table class="table">
                    <thead class="thead-dark">
                        <tr>
                            <th>#</th>
                            <th>No. Empleado</th>
                            <th>Fecha</th>
                            <th>Respuesta 1 (Fiebre)</th>
                            <th>Respuesta 2 (Tos)</th>
                            <th>Respuesta 3 (Dificultad respiratoria)</th>
                            <th>Respuesta 4 (Dolor de cabeza intenso)</th>
                            <th>Respuesta 5 (Contacto directo)</th>
                            <th>Resultado</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($all as $a):?>
                        <tr class="table-<?php echo $a['resultado'];?>">
                            <th scope="row"><?php echo $a['id_reg'];?></th>
                            <td><?php echo $a['no_emp'];?></td>
                            <td><?php echo $a['fecha_reg'];?></td>
                            <td><?php echo $a['p_uno'];?></td>
                            <td><?php echo $a['p_dos'];?></td>
                            <td><?php echo $a['p_tres'];?></td>
                            <td><?php echo $a['p_cinco'];?></td>
                            <td><?php echo $a['p_cuatro'];?></td>
                            <td><?php echo $a['resultado'];?></td>
                        </tr>
                        <?php endforeach;?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    
    <!-- Optional JavaScript -->
    <!-- jQuery first, then Popper.js, then Bootstrap JS -->
    <script src="https://code.jquery.com/jquery-3.5.1.min.js" integrity="sha256-9/aliU8dGd2tb6OSsuzixeV4y/faTqgFtohetphbbj0=" crossorigin="anonymous"></script>
    <!-- <script src="https://code.jquery.com/jquery-1.12.4.js"></script> -->
    <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js" integrity="sha384-UO2eT0CpHqdSJQ6hJty5KVphtPhzWj9WO1clHTMGa3JDZwrnQq4sF86dIHNDz0W1" crossorigin="anonymous"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js" integrity="sha384-JjSmVgyd0p3pXB1rRibZUAYoIIy6OrQ6VrjIEaFf/nJGzIxFDsf4x0xIM+B07jRM" crossorigin="anonymous"></script>

    <script>
    $( function() {
        $( "#inicio" ).datepicker({
            dateFormat: "dd/mm/yy"
        });
        $("#fin").datepicker({
            dateFormat: "dd/mm/yy"
        });
    } );
  </script>
  </body>
</html>